/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;

public class FileGroupingJavac
extends Javac {
    public static final int DEFAULT_GROUP_SIZE = 100;
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private int m_iGroupSize = 100;

    public void setGroupsize(int newSize) {
        this.m_iGroupSize = newSize;
    }

    public int getGroupsize() {
        return this.m_iGroupSize;
    }

    protected void compile() {
        int numGroups = this.compileList.length / this.m_iGroupSize;
        if ((numGroups += this.compileList.length % this.m_iGroupSize == 0 ? 0 : 1) <= 1) {
            super.compile();
            return;
        }
        this.log(String.valueOf(this.compileList.length) + " total files. Dividing files into " + numGroups + " groups of maximum " + this.m_iGroupSize + " files.");
        String compilerImpl = this.getCompiler();
        CompilerAdapter adapter = CompilerAdapterFactory.getCompiler((String)compilerImpl, (Task)this);
        File destDir = this.getDestdir();
        File[] compileListOrig = this.compileList;
        int currGroup = 0;
        int currGroupSize = 0;
        int currFile = 0;
        currGroup = 0;
        currFile = 0;
        while (currGroup < numGroups) {
            currGroupSize = currGroup == numGroups - 1 ? compileListOrig.length / numGroups + compileListOrig.length % numGroups : compileListOrig.length / numGroups;
            if (this.compileList == null || this.compileList.length != currGroupSize) {
                this.compileList = new File[currGroupSize];
            }
            System.arraycopy(compileListOrig, currFile, this.compileList, 0, currGroupSize);
            this.log("Compiling source files " + (currFile + 1) + " to " + (currFile + currGroupSize) + (destDir != null ? " to " + destDir : ""));
            if (this.listFiles) {
                int i = 0;
                while (i < currGroupSize) {
                    String filename = this.compileList[i].getAbsolutePath();
                    this.log(filename);
                    ++i;
                }
            }
            adapter.setJavac((Javac)this);
            if (!adapter.execute()) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
            ++currGroup;
            currFile += currGroupSize;
        }
        this.compileList = compileListOrig;
    }
}

