/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.jdbcstatwrapper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class JDBCStatWrapperMonitor {
    protected static Map queryStats = new HashMap();
    protected static QueryStats totalStats = new QueryStats();
    protected static long connectionsOpened = 0L;
    protected static long connectionsClosed = 0L;
    protected static Map objectsCreated = new HashMap();
    protected static Map objectsClosedStacks = new HashMap();
    protected static Set objectsNotClosed = new HashSet();
    protected static Set objectsClosed = new HashSet();
    protected static Set objectsClosedMultipleTimes = new HashSet();
    protected static Set statementsExecuted = new HashSet();
    protected static Set statementsNotExecuted = new HashSet();
    protected static Set statementsExecutedMultipleTimes = new HashSet();
    private static final String PARAM_KEY_SEP = ",";
    private static final String PARAM_KEY_NULL = "<null params>";
    static /* synthetic */ Class class$0;

    static String makeKeyFromParamMap(SortedMap params) {
        if (params == null || params.size() == 0) {
            return PARAM_KEY_NULL;
        }
        StringBuffer buff = new StringBuffer(100);
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            buff.append(params.get(it.next()).toString()).append(PARAM_KEY_SEP);
        }
        buff.delete(buff.length() - PARAM_KEY_SEP.length(), buff.length());
        return buff.toString();
    }

    public static long getConnectionsClosed() {
        return connectionsClosed;
    }

    public static void setConnectionsClosed(long connectionsClosed) {
        JDBCStatWrapperMonitor.connectionsClosed = connectionsClosed;
    }

    public static long getConnectionsOpened() {
        return connectionsOpened;
    }

    public static void setConnectionsOpened(long connectionsOpened) {
        JDBCStatWrapperMonitor.connectionsOpened = connectionsOpened;
    }

    public static void incrementTimesExecuted(String query, SortedMap params, long execTime, int objectId) {
        if (query != null) {
            QueryStats stats = (QueryStats)queryStats.get(query);
            if (stats == null) {
                stats = new QueryStats();
                stats.setQuery(query);
                queryStats.put(query, stats);
            }
            stats.getParams().add(JDBCStatWrapperMonitor.makeKeyFromParamMap(params));
            ++stats.timesExecuted;
            stats.totalExecutionTime += execTime;
        }
        ++JDBCStatWrapperMonitor.totalStats.timesExecuted;
        JDBCStatWrapperMonitor.totalStats.totalExecutionTime += execTime;
        JDBCStatWrapperMonitor.executeStatement(objectId);
    }

    public static void incrementResultSetsOpened(String query, SortedMap params, int objectId) {
        if (query != null) {
            QueryStats stats = (QueryStats)queryStats.get(query);
            if (stats == null) {
                stats = new QueryStats();
                stats.setQuery(query);
                queryStats.put(query, stats);
            }
            stats.getParams().add(JDBCStatWrapperMonitor.makeKeyFromParamMap(params));
            ++stats.resultSetsOpened;
        }
        ++JDBCStatWrapperMonitor.totalStats.resultSetsOpened;
        JDBCStatWrapperMonitor.openObject(objectId);
    }

    public static void incrementResultSetsClosed(String query, SortedMap params, int objectId) {
        if (query != null) {
            QueryStats stats = (QueryStats)queryStats.get(query);
            if (stats == null) {
                stats = new QueryStats();
                stats.setQuery(query);
                queryStats.put(query, stats);
            }
            stats.getParams().add(JDBCStatWrapperMonitor.makeKeyFromParamMap(params));
            ++stats.resultSetsClosed;
        }
        ++JDBCStatWrapperMonitor.totalStats.resultSetsClosed;
        JDBCStatWrapperMonitor.closeObject(objectId);
    }

    public static void incrementStatementsOpened(String query, int objectId) {
        if (query != null) {
            QueryStats stats = (QueryStats)queryStats.get(query);
            if (stats == null) {
                stats = new QueryStats();
                stats.setQuery(query);
                queryStats.put(query, stats);
            }
            ++stats.statementsOpened;
        }
        ++JDBCStatWrapperMonitor.totalStats.statementsOpened;
        JDBCStatWrapperMonitor.openObject(objectId);
        statementsNotExecuted.add(new Integer(objectId));
    }

    public static void incrementStatementsClosed(String query, int objectId) {
        if (query != null) {
            QueryStats stats = (QueryStats)queryStats.get(query);
            if (stats == null) {
                stats = new QueryStats();
                stats.setQuery(query);
                queryStats.put(query, stats);
            }
            ++stats.statementsClosed;
        }
        ++JDBCStatWrapperMonitor.totalStats.statementsClosed;
        JDBCStatWrapperMonitor.closeObject(objectId);
    }

    public static void incrementConnectionsOpened(int objectId) {
        ++connectionsOpened;
        JDBCStatWrapperMonitor.openObject(objectId);
    }

    public static void incrementConnectionsClosed(int objectId) {
        ++connectionsClosed;
        JDBCStatWrapperMonitor.closeObject(objectId);
    }

    private static void openObject(int objectId) {
        Integer i = new Integer(objectId);
        StackTraceElement[] stack = JDBCStatWrapperMonitor.getUnwrappedStackTrace();
        objectsCreated.put(i, stack);
        objectsNotClosed.add(i);
    }

    private static void closeObject(int objectId) {
        Integer i = new Integer(objectId);
        objectsNotClosed.remove(i);
        if (objectsClosed.contains(i)) {
            objectsClosedMultipleTimes.add(i);
        } else {
            objectsClosed.add(i);
        }
        ArrayList<StackTraceElement[]> closingStacks = (ArrayList<StackTraceElement[]>)objectsClosedStacks.get(i);
        if (closingStacks == null) {
            closingStacks = new ArrayList<StackTraceElement[]>();
            objectsClosedStacks.put(i, closingStacks);
        }
        closingStacks.add(JDBCStatWrapperMonitor.getUnwrappedStackTrace());
    }

    private static void executeStatement(int objectId) {
        Integer i = new Integer(objectId);
        statementsNotExecuted.remove(i);
        if (statementsExecuted.contains(i)) {
            statementsExecutedMultipleTimes.add(i);
        } else {
            statementsExecuted.add(i);
        }
    }

    private static boolean isStackTraceElementPartOfThisPackage(StackTraceElement ste) {
        String string = ste.getClassName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return string.startsWith(clazz.getPackage().getName());
    }

    /*
     * Unable to fully structure code
     */
    private static StackTraceElement[] getUnwrappedStackTrace() {
        block4: {
            stack = null;
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.fillInStackTrace();
                stack = e.getStackTrace();
                if (stack == null || stack.length <= 0) break block4;
                stackIndx = 0;
                ** while (stackIndx < stack.length && JDBCStatWrapperMonitor.isStackTraceElementPartOfThisPackage((StackTraceElement)stack[stackIndx]))
            }
lbl-1000:
            // 1 sources

            {
                ++stackIndx;
                continue;
            }
lbl13:
            // 1 sources

            if (stackIndx < stack.length) {
                stackShort = new StackTraceElement[stack.length - stackIndx];
                System.arraycopy(stack, stackIndx, stackShort, 0, stack.length - stackIndx);
                stack = stackShort;
            }
        }
        return stack;
    }

    private static String getFormattedPercent(double percentRaw, int precision) {
        precision = Math.abs(precision);
        double percentLeftD = Math.floor(percentRaw * 100.0);
        long percentRight = (long)((percentRaw - percentLeftD / 100.0) * (1000.0 * (double)precision));
        return String.valueOf((long)percentLeftD) + (precision >= 1 ? "." + percentRight : "") + "%";
    }

    public static void logStats() {
        PrintStream ps = System.out;
        ps.println("Total JDBC Stats");
        ps.println("==========");
        ps.println("Total Connection Opened: " + JDBCStatWrapperMonitor.getConnectionsOpened());
        ps.println("Total Connection Closed: " + JDBCStatWrapperMonitor.getConnectionsClosed());
        ps.println("Total Statements Opened: " + totalStats.getStatementsOpened());
        ps.println("Total Statements Closed: " + totalStats.getStatementsClosed());
        ps.println("Total Queries Executed : " + totalStats.getTimesExecuted());
        ps.println("Total Exec Time        : " + totalStats.getTotalExecutionTime());
        ps.println("Total Avg Exec Time    : " + totalStats.getAverageExecutionTime());
        ps.println("Total ResultSets Opened: " + totalStats.getResultSetsOpened());
        ps.println("Total ResultSets Closed: " + totalStats.getResultSetsClosed());
        ps.println("==========");
        ps.println("StackTrace of unclosed objects:");
        int x = 0;
        Iterator<Object> it = objectsNotClosed.iterator();
        while (it.hasNext()) {
            ps.println("Object " + ++x);
            StackTraceElement[] stack = (StackTraceElement[])objectsCreated.get(it.next());
            if (stack == null) continue;
            int i = 0;
            while (i < stack.length) {
                ps.println("\t\t" + stack[i].toString());
                ++i;
            }
        }
        ps.println("==========");
        ps.println("StackTrace of objects closed multiple times:");
        x = 0;
        it = objectsClosedMultipleTimes.iterator();
        while (it.hasNext()) {
            Integer objectId = (Integer)it.next();
            ps.println("Object " + ++x);
            StackTraceElement[] stack = (StackTraceElement[])objectsCreated.get(objectId);
            int i = 0;
            while (i < stack.length) {
                ps.println("\t\t" + stack[i].toString());
                ++i;
            }
            ps.println("\t\t==========");
            ps.println("\t\tStackTrace of each closing:");
            List closings = (List)objectsClosedStacks.get(objectId);
            int y = 0;
            while (y < closings.size()) {
                ps.println("\t\tClosing " + y);
                StackTraceElement[] stackClosing = (StackTraceElement[])closings.get(y);
                int i2 = 0;
                while (i2 < stackClosing.length) {
                    ps.println("\t\t\t" + stackClosing[i2].toString());
                    ++i2;
                }
                ++y;
            }
        }
        ps.println("==========");
        ps.println("Per-Query JDBC Stats");
        it = queryStats.values().iterator();
        while (it.hasNext()) {
            QueryStats perQueryStats = (QueryStats)it.next();
            ps.println("\t==========");
            ps.println("\tQuery: " + perQueryStats.getQuery());
            ps.println("\t\tStatements Opened: " + perQueryStats.getStatementsOpened());
            ps.println("\t\tStatements Closed: " + perQueryStats.getStatementsClosed() + (perQueryStats.getStatementsClosed() < perQueryStats.getStatementsOpened() ? "\t\t\tSTATEMENTS NOT CLOSED" : ""));
            ps.println("\t\tQueries Executed : " + perQueryStats.getTimesExecuted() + (perQueryStats.getStatementsOpened() > perQueryStats.getTimesExecuted() ? "\t\t\tUNUSED STATEMENTS OPENED" : ""));
            ps.println("\t\tTotal Exec Time  : " + perQueryStats.getTotalExecutionTime());
            ps.println("\t\tAvg Exec Time    : " + perQueryStats.getAverageExecutionTime());
            ps.println("\t\tPercent of Total : " + JDBCStatWrapperMonitor.getFormattedPercent(perQueryStats.getPercentExecutionTime(), 1));
            ps.println("\t\tResultSets Opened: " + perQueryStats.getResultSetsOpened());
            ps.println("\t\tResultSets Closed: " + perQueryStats.getResultSetsClosed() + (perQueryStats.getResultSetsClosed() < perQueryStats.getResultSetsOpened() ? "\t\t\tRESULTSETS NOT CLOSED" : ""));
            ps.println("\t\tUniqueParams Used: " + perQueryStats.getParams().size() + (perQueryStats.getParams().size() != 0 && (long)perQueryStats.getParams().size() < perQueryStats.getTimesExecuted() ? "\t\t\tDUPLICATE QUERIES ISSUED" : ""));
        }
    }

    public static class QueryStats {
        protected String query;
        protected Set uniqueParams = new HashSet();
        protected long resultSetsOpened;
        protected long resultSetsClosed;
        protected long statementsOpened;
        protected long statementsClosed;
        protected long timesExecuted;
        protected long totalExecutionTime;

        public long getAverageExecutionTime() {
            try {
                return this.totalExecutionTime / this.timesExecuted;
            }
            catch (Exception exception) {
                return 0L;
            }
        }

        public Set getParams() {
            return this.uniqueParams;
        }

        public void setParams(Set uniqueParams) {
            this.uniqueParams = uniqueParams;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public long getResultSetsClosed() {
            return this.resultSetsClosed;
        }

        public void setResultSetsClosed(long resultSetsClosed) {
            this.resultSetsClosed = resultSetsClosed;
        }

        public long getResultSetsOpened() {
            return this.resultSetsOpened;
        }

        public void setResultSetsOpened(long resultSetsOpened) {
            this.resultSetsOpened = resultSetsOpened;
        }

        public long getStatementsClosed() {
            return this.statementsClosed;
        }

        public void setStatementsClosed(long statementsClosed) {
            this.statementsClosed = statementsClosed;
        }

        public long getStatementsOpened() {
            return this.statementsOpened;
        }

        public void setStatementsOpened(long statementsOpened) {
            this.statementsOpened = statementsOpened;
        }

        public long getTotalExecutionTime() {
            return this.totalExecutionTime;
        }

        public void setTotalExecutionTime(long totalExecutionTime) {
            this.totalExecutionTime = totalExecutionTime;
        }

        public long getTimesExecuted() {
            return this.timesExecuted;
        }

        public void setTimesExecuted(long timesExecuted) {
            this.timesExecuted = timesExecuted;
        }

        public double getPercentExecutionTime() {
            return (double)this.getTotalExecutionTime() / (double)totalStats.getTotalExecutionTime();
        }
    }
}

