/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.jdbcstatwrapper;

import com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor;
import com.jimischopp.jdbcstatwrapper.StatCallableStatement;
import com.jimischopp.jdbcstatwrapper.StatPreparedStatement;
import com.jimischopp.jdbcstatwrapper.StatStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class StatConnection
implements Connection {
    protected Connection delegate;

    public StatConnection(Connection delegate) {
        this.delegate = delegate;
        JDBCStatWrapperMonitor.incrementConnectionsOpened(delegate.hashCode());
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Connection delegate) {
        this.delegate = delegate;
    }

    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    public void close() throws SQLException {
        this.delegate.close();
        JDBCStatWrapperMonitor.incrementConnectionsClosed(this.delegate.hashCode());
    }

    public void commit() throws SQLException {
        this.delegate.commit();
    }

    public Statement createStatement() throws SQLException {
        return new StatStatement(this.delegate.createStatement());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatStatement(this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatStatement(this.delegate.createStatement(resultSetType, resultSetConcurrency));
    }

    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatCallableStatement(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatCallableStatement(this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new StatCallableStatement(this.delegate.prepareCall(sql), sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatPreparedStatement(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatPreparedStatement(this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new StatPreparedStatement(this.delegate.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new StatPreparedStatement(this.delegate.prepareStatement(sql, columnIndexes), sql);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new StatPreparedStatement(this.delegate.prepareStatement(sql, columnNames), sql);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new StatPreparedStatement(this.delegate.prepareStatement(sql), sql);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.delegate.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.delegate.setTypeMap(map);
    }
}

