/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.jdbcstatwrapper;

import com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor;
import com.jimischopp.jdbcstatwrapper.StatResultSet;
import com.jimischopp.jdbcstatwrapper.StatStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TreeMap;

public class StatPreparedStatement
extends StatStatement
implements PreparedStatement {
    protected static final String BATCHPARAM_PREFIX = "Batch_";
    protected int batchCount = 0;

    public StatPreparedStatement(PreparedStatement delegate, String query) {
        super(delegate, query);
    }

    public void addBatch() throws SQLException {
        ((PreparedStatement)this.delegate).addBatch();
        TreeMap mapCurrentBatch = new TreeMap();
        Iterator it = this.params.keySet().iterator();
        while (it.hasNext()) {
            Object i = it.next();
            if (!(i instanceof Iterator)) continue;
            mapCurrentBatch.put(i, this.params.get(i));
            this.params.remove(i);
        }
        String consolidateParamsThisBatch = JDBCStatWrapperMonitor.makeKeyFromParamMap(mapCurrentBatch);
        this.params.put(BATCHPARAM_PREFIX + ++this.batchCount, consolidateParamsThisBatch);
    }

    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.delegate).clearParameters();
    }

    public boolean execute() throws SQLException {
        long start = System.currentTimeMillis();
        boolean ret = ((PreparedStatement)this.delegate).execute();
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public ResultSet executeQuery() throws SQLException {
        long start = System.currentTimeMillis();
        ResultSet ret = ((PreparedStatement)this.delegate).executeQuery();
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return new StatResultSet(ret, this.query, this.params);
    }

    public int executeUpdate() throws SQLException {
        long start = System.currentTimeMillis();
        int ret = ((PreparedStatement)this.delegate).executeUpdate();
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.delegate).getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.delegate).getParameterMetaData();
    }

    public void setArray(int i, Array x) throws SQLException {
        ((PreparedStatement)this.delegate).setArray(i, x);
        this.params.put(new Integer(i), "array");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.delegate).setAsciiStream(parameterIndex, x, length);
        this.params.put(new Integer(parameterIndex), "ascii stream");
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        ((PreparedStatement)this.delegate).setBigDecimal(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.delegate).setBinaryStream(parameterIndex, x, length);
        this.params.put(new Integer(parameterIndex), "input stream");
    }

    public void setBlob(int i, Blob x) throws SQLException {
        ((PreparedStatement)this.delegate).setBlob(i, x);
        this.params.put(new Integer(i), "blob");
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        ((PreparedStatement)this.delegate).setBoolean(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Boolean(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        ((PreparedStatement)this.delegate).setByte(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Byte(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        ((PreparedStatement)this.delegate).setBytes(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), "byte array");
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        ((PreparedStatement)this.delegate).setCharacterStream(parameterIndex, reader, length);
        this.params.put(new Integer(parameterIndex), "character stream");
    }

    public void setClob(int i, Clob x) throws SQLException {
        ((PreparedStatement)this.delegate).setClob(i, x);
        this.params.put(new Integer(i), "clob");
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.delegate).setDate(parameterIndex, x, cal);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        ((PreparedStatement)this.delegate).setDate(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        ((PreparedStatement)this.delegate).setDouble(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Double(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        ((PreparedStatement)this.delegate).setFloat(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Float(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        ((PreparedStatement)this.delegate).setInt(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Integer(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        ((PreparedStatement)this.delegate).setLong(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Long(x));
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        ((PreparedStatement)this.delegate).setNull(paramIndex, sqlType, typeName);
        this.params.put(new Integer(paramIndex), "null");
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        ((PreparedStatement)this.delegate).setNull(parameterIndex, sqlType);
        this.params.put(new Integer(parameterIndex), "null");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        ((PreparedStatement)this.delegate).setObject(parameterIndex, x, targetSqlType, scale);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        ((PreparedStatement)this.delegate).setObject(parameterIndex, x, targetSqlType);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        ((PreparedStatement)this.delegate).setObject(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setRef(int i, Ref x) throws SQLException {
        ((PreparedStatement)this.delegate).setRef(i, x);
        this.params.put(new Integer(i), "ref");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        ((PreparedStatement)this.delegate).setShort(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), new Short(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        ((PreparedStatement)this.delegate).setString(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.delegate).setTime(parameterIndex, x, cal);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        ((PreparedStatement)this.delegate).setTime(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        ((PreparedStatement)this.delegate).setTimestamp(parameterIndex, x, cal);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ((PreparedStatement)this.delegate).setTimestamp(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        ((PreparedStatement)this.delegate).setUnicodeStream(parameterIndex, x, length);
        this.params.put(new Integer(parameterIndex), "input stream");
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        ((PreparedStatement)this.delegate).setURL(parameterIndex, x);
        this.params.put(new Integer(parameterIndex), x);
    }
}

