/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.jdbcstatwrapper;

import com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor;
import com.jimischopp.jdbcstatwrapper.StatConnection;
import com.jimischopp.jdbcstatwrapper.StatResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.SortedMap;
import java.util.TreeMap;

public class StatStatement
implements Statement {
    protected Statement delegate;
    protected String query;
    protected SortedMap params = new TreeMap();

    public StatStatement(Statement delegate) {
        this(delegate, null);
    }

    public StatStatement(Statement delegate, String sql) {
        this.delegate = delegate;
        this.query = sql;
        JDBCStatWrapperMonitor.incrementStatementsOpened(sql, delegate.hashCode());
    }

    public Statement getDelegate() {
        return this.delegate;
    }

    public void addBatch(String sql) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        this.delegate.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    public void close() throws SQLException {
        JDBCStatWrapperMonitor.incrementStatementsClosed(this.query, this.delegate.hashCode());
        this.delegate.close();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        boolean ret = this.delegate.execute(sql, autoGeneratedKeys);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        boolean ret = this.delegate.execute(sql, columnIndexes);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        boolean ret = this.delegate.execute(sql, columnNames);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public boolean execute(String sql) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        boolean ret = this.delegate.execute(sql);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public int[] executeBatch() throws SQLException {
        long start = System.currentTimeMillis();
        int[] ret = this.delegate.executeBatch();
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        ResultSet ret = this.delegate.executeQuery(sql);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return new StatResultSet(ret, this.query, this.params);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        int ret = this.delegate.executeUpdate(sql, autoGeneratedKeys);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        int ret = this.delegate.executeUpdate(sql, columnIndexes);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        int ret = this.delegate.executeUpdate(sql, columnNames);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public int executeUpdate(String sql) throws SQLException {
        if (!sql.equals(this.query)) {
            this.query = sql;
            JDBCStatWrapperMonitor.incrementStatementsOpened(this.query, this.delegate.hashCode());
        }
        long start = System.currentTimeMillis();
        int ret = this.delegate.executeUpdate(sql);
        long stop = System.currentTimeMillis();
        JDBCStatWrapperMonitor.incrementTimesExecuted(this.query, this.params, stop - start, this.delegate.hashCode());
        return ret;
    }

    public Connection getConnection() throws SQLException {
        if (this.delegate.getConnection() instanceof StatConnection) {
            return this.delegate.getConnection();
        }
        return new StatConnection(this.delegate.getConnection());
    }

    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new StatResultSet(this.delegate.getGeneratedKeys(), this.query, this.params);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return new StatResultSet(this.delegate.getResultSet(), this.query, this.params);
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }
}

