/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */
package com.jimischopp.jdbcstatwrapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/**
 * CallableStatement wrapper for the JDBCStatWrapper JDBC tracing utility.
 *  
 * <p>
 * Copyright 2007, James Schopp
 * </p>
 * 
 * @see com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor
 * @author James Schopp
 * @since Jan 31, 2007
 *
 */
public class StatCallableStatement extends StatPreparedStatement implements CallableStatement {
    
    public StatCallableStatement(CallableStatement delegate, String query) {
        super(delegate, query);        
    }

    public Array getArray(int i) throws SQLException {
        return ((CallableStatement)delegate).getArray(i);
    }

    public Array getArray(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getArray(parameterName);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return ((CallableStatement)delegate).getBigDecimal(parameterIndex, scale);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getBigDecimal(parameterIndex);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getBigDecimal(parameterName);
    }

    public Blob getBlob(int i) throws SQLException {
        return ((CallableStatement)delegate).getBlob(i);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getBlob(parameterName);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getBoolean(parameterIndex);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getBoolean(parameterName);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getByte(parameterIndex);
    }

    public byte getByte(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getByte(parameterName);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getBytes(parameterIndex);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getBytes(parameterName);
    }

    public Clob getClob(int i) throws SQLException {
        return ((CallableStatement)delegate).getClob(i);
    }

    public Clob getClob(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getClob(parameterName);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)delegate).getDate(parameterIndex, cal);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getDate(parameterIndex);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return ((CallableStatement)delegate).getDate(parameterName, cal);
    }

    public Date getDate(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getDate(parameterName);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getDouble(parameterIndex);
    }

    public double getDouble(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getDouble(parameterName);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getFloat(parameterIndex);
    }

    public float getFloat(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getFloat(parameterName);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getInt(parameterIndex);
    }

    public int getInt(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getInt(parameterName);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getLong(parameterIndex);
    }

    public long getLong(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getLong(parameterName);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return ((CallableStatement)delegate).getObject(i, map);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getObject(parameterIndex);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return ((CallableStatement)delegate).getObject(parameterName, map);
    }

    public Object getObject(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getObject(parameterName);
    }

    public Ref getRef(int i) throws SQLException {
        return ((CallableStatement)delegate).getRef(i);
    }

    public Ref getRef(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getRef(parameterName);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getShort(parameterIndex);
    }

    public short getShort(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getShort(parameterName);
    }

    public String getString(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getString(parameterIndex);
    }

    public String getString(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getString(parameterName);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)delegate).getTime(parameterIndex, cal);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getTime(parameterIndex);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return ((CallableStatement)delegate).getTime(parameterName, cal);
    }

    public Time getTime(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getTime(parameterName);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)delegate).getTimestamp(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return ((CallableStatement)delegate).getTimestamp(parameterName, cal);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getTimestamp(parameterName);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return ((CallableStatement)delegate).getURL(parameterIndex);
    }

    public URL getURL(String parameterName) throws SQLException {
        return ((CallableStatement)delegate).getURL(parameterName);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        ((CallableStatement)delegate).registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)delegate).registerOutParameter(paramIndex, sqlType, typeName);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        ((CallableStatement)delegate).registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        ((CallableStatement)delegate).registerOutParameter(parameterName, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)delegate).registerOutParameter(parameterName, sqlType, typeName);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        ((CallableStatement)delegate).registerOutParameter(parameterName, sqlType);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {        
        ((CallableStatement)delegate).setAsciiStream(parameterName, x, length);
        
        params.put(parameterName, "ascii stream");
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        ((CallableStatement)delegate).setBigDecimal(parameterName, x);
        
        params.put(parameterName, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        ((CallableStatement)delegate).setBinaryStream(parameterName, x, length);
        
        params.put(parameterName, "input stream");
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        ((CallableStatement)delegate).setBoolean(parameterName, x);
        
        params.put(parameterName, new Boolean(x));
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        ((CallableStatement)delegate).setByte(parameterName, x);
        
        params.put(parameterName, new Byte(x));
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        ((CallableStatement)delegate).setBytes(parameterName, x);
        
        params.put(parameterName, "byte array");
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        ((CallableStatement)delegate).setCharacterStream(parameterName, reader, length);
        
        params.put(parameterName, "character stream");
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        ((CallableStatement)delegate).setDate(parameterName, x, cal);
        
        params.put(parameterName, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        ((CallableStatement)delegate).setDate(parameterName, x);
        
        params.put(parameterName, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        ((CallableStatement)delegate).setDouble(parameterName, x);
        
        params.put(parameterName, new Double(x));
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        ((CallableStatement)delegate).setFloat(parameterName, x);
        
        params.put(parameterName, new Float(x));
    }


    public void setInt(String parameterName, int x) throws SQLException {
        ((CallableStatement)delegate).setInt(parameterName, x);
        
        params.put(parameterName, new Integer(x));
    }

    public void setLong(String parameterName, long x) throws SQLException {
        ((CallableStatement)delegate).setLong(parameterName, x);
        
        params.put(parameterName, new Long(x));
    }


    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)delegate).setNull(parameterName, sqlType, typeName);
        
        params.put(parameterName, "null");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        ((CallableStatement)delegate).setNull(parameterName, sqlType);
        
        params.put(parameterName, "null");
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        ((CallableStatement)delegate).setObject(parameterName, x, targetSqlType, scale);
        
        params.put(parameterName, x);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        ((CallableStatement)delegate).setObject(parameterName, x, targetSqlType);
        
        params.put(parameterName, x);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        ((CallableStatement)delegate).setObject(parameterName, x);
        
        params.put(parameterName, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        ((CallableStatement)delegate).setShort(parameterName, x);
        
        params.put(parameterName, new Short(x));
    }

    public void setString(String parameterName, String x) throws SQLException {
        ((CallableStatement)delegate).setString(parameterName, x);
        
        params.put(parameterName, x);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        ((CallableStatement)delegate).setTime(parameterName, x, cal);
        
        params.put(parameterName, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        ((CallableStatement)delegate).setTime(parameterName, x);
        
        params.put(parameterName, x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        ((CallableStatement)delegate).setTimestamp(parameterName, x, cal);
        
        params.put(parameterName, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        ((CallableStatement)delegate).setTimestamp(parameterName, x);
        
        params.put(parameterName, x);
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        ((CallableStatement)delegate).setURL(parameterName, val);
        
        params.put(parameterName, val);
    }

    public boolean wasNull() throws SQLException {
        return ((CallableStatement)delegate).wasNull();
    }
}
