/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */
package com.jimischopp.jdbcstatwrapper;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

/**
 * Connectiom wrapper for the JDBCStatWrapper JDBC tracing utility.
 *  
 * <p>
 * Copyright 2007, James Schopp
 * </p>
 *
 * @see com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor
 * @author James Schopp
 * @since Jan 31, 2007
 *
 */
public class StatConnection implements Connection {
    
    protected Connection delegate;    
    
    public StatConnection(Connection delegate) {
        super();
        this.delegate = delegate;        
        JDBCStatWrapperMonitor.incrementConnectionsOpened(delegate.hashCode());        
    }

    public Connection getDelegate() {
        return delegate;
    }

    public void setDelegate(Connection delegate) {
        this.delegate = delegate;
    }

    public void clearWarnings() throws SQLException {
        delegate.clearWarnings();
    }

    public void close() throws SQLException {
        delegate.close();
        JDBCStatWrapperMonitor.incrementConnectionsClosed(delegate.hashCode());
    }

    public void commit() throws SQLException {
        delegate.commit();
    }

    public Statement createStatement() throws SQLException {
        return new StatStatement(delegate.createStatement());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatStatement(delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatStatement(delegate.createStatement(resultSetType, resultSetConcurrency));
    }

    public boolean getAutoCommit() throws SQLException {
        return delegate.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return delegate.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return delegate.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return delegate.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return delegate.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return delegate.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return delegate.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return delegate.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return delegate.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return delegate.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatCallableStatement(delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatCallableStatement(delegate.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new StatCallableStatement(delegate.prepareCall(sql), sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatPreparedStatement(delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatPreparedStatement(delegate.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new StatPreparedStatement(delegate.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new StatPreparedStatement(delegate.prepareStatement(sql, columnIndexes), sql);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new StatPreparedStatement(delegate.prepareStatement(sql, columnNames), sql);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new StatPreparedStatement(delegate.prepareStatement(sql), sql);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        delegate.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        delegate.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        delegate.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        delegate.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        delegate.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        delegate.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        delegate.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        return delegate.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return delegate.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        delegate.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        delegate.setTypeMap(map);
    }
}
