/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */
package com.jimischopp.jdbcstatwrapper;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

/**
 * Driver wrapper for the JDBCStatWrapper JDBC tracing utility.
 *  
 * <p>
 * Copyright 2007, James Schopp
 * </p>
 * 
 * @see com.jimischopp.jdbcstatwrapper.JDBCStatWrapperMonitor
 * @author James Schopp
 * @since Jan 31, 2007
 *
 */
public class StatDriver implements Driver {
    
    static {
        try {
            DriverManager.registerDriver(new StatDriver());            
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
    
    public Driver delegate;
    
    public final static String URL_PREFIX = "jdbc:statJdbcDriver:";

    public boolean acceptsURL(String url) throws SQLException {        
        if (url.startsWith(URL_PREFIX)) {
            return true;
        }
        return false;        
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String newUrl = "jdbc:" + url.substring(URL_PREFIX.length());
        delegate = DriverManager.getDriver(newUrl);
        Connection conn = delegate.connect(newUrl, info);
        if (conn == null) return null;
        return new StatConnection(conn);
    }

    public int getMajorVersion() {
        return delegate.getMajorVersion();
    }

    public int getMinorVersion() {
        return delegate.getMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return delegate.getPropertyInfo(url, info);
    }

    public boolean jdbcCompliant() {
        return delegate.jdbcCompliant();
    }    
}
