/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.jyoutube;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JYouTube
implements ProgressReportingFilePart.ProgressListener {
    protected static final Log log = LogFactory.getLog(JYouTube.class);
    public static final String YT_COOKIE_LOGININFO = "LOGIN_INFO";
    public static final String YT_URL_LOGIN_USERNAME_KEY = "$USERNAME$";
    public static final String YT_URL_LOGIN_PASSWORD_KEY = "$PASSWORD$";
    public static final String YT_URL_VIDEOID_KEY = "$VIDEOID$";
    public static final String YT_URL_VIDEOIDTEMP_KEY = "$TEMPID$";
    public static final String YT_URL_ROOT = "http://www.youtube.com:80";
    public static final String YT_URL_LOGIN = "http://www.youtube.com:80/login?username=$USERNAME$&password=$PASSWORD$&next=/index&current_form=loginForm&action_login=1";
    public static final String YT_URL_VIEW = "http://www.youtube.com:80/watch?v=$VIDEOID$";
    public static final String YT_URL_GET = "http://www.youtube.com:80/get_video?video_id=$VIDEOID$&t=$TEMPID$";
    public static final String YT_URL_PUT_MYVIDEOUPLOAD = "http://www.youtube.com:80/my_videos_upload";
    public static final String YT_URL_MYVIDEOS = "http://www.youtube.com:80/my_videos";
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)";
    protected HttpClient httpclient;
    protected boolean auth = false;
    private static final Pattern pTEMPID = Pattern.compile("t:'(([a-zA-Z0-9_\\-]+))'");
    protected Collection<ProgressReportingFilePart.ProgressListener> listeners = new HashSet<ProgressReportingFilePart.ProgressListener>();

    protected HttpClient getHttpClient() {
        return this.httpclient;
    }

    public JYouTube() throws Exception {
        this(null, null);
    }

    public void setProxy(String proxyHostName, int proxyPort) {
        this.httpclient.getHostConfiguration().setProxy(proxyHostName, proxyPort);
    }

    public JYouTube(String username, String password) throws Exception {
        this.httpclient = JYouTube.getNewHttpClient();
        if (JYouTube.isNullOrEmpty(username) || JYouTube.isNullOrEmpty(password)) {
            this.auth = false;
            log.debug((Object)"No user/pass specified. Uploading will be disabled.");
            return;
        }
        String url = JYouTube.getYouTubeLoginUrl(username, password);
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(true);
        method.setRequestHeader("User-Agent", USER_AGENT);
        try {
            log.debug((Object)("Making request to: " + url));
            int result = this.httpclient.executeMethod((HttpMethod)method);
            if (200 != result) {
                throw new Exception("HTTP Exception + " + result + " " + method.getStatusLine().toString());
            }
        }
        finally {
            method.releaseConnection();
        }
        this.auth = true;
        Cookie[] cookies = this.httpclient.getState().getCookies();
        boolean success = false;
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (YT_COOKIE_LOGININFO.equals(cookie.getName()) && !JYouTube.isNullOrEmpty(cookie.getValue())) {
                success = true;
                break;
            }
            ++i;
        }
        if (!success) {
            this.auth = false;
            throw new Exception("Login failed!");
        }
    }

    public void download(String videoId, String videoFilename) throws Exception {
        String url = JYouTube.getYouTubeViewUrl(videoId);
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(true);
        method.setRequestHeader("User-Agent", USER_AGENT);
        String pageHtml = null;
        try {
            log.debug((Object)("Making request to: " + url));
            int result = this.httpclient.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new Exception("HTTP Exception + " + result + " " + method.getStatusLine().toString());
            }
            pageHtml = method.getResponseBodyAsString();
            if (JYouTube.isNullOrEmpty(pageHtml)) {
                throw new Exception("Empty response from YouTube server!");
            }
        }
        finally {
            method.releaseConnection();
        }
        Matcher m = pTEMPID.matcher(pageHtml);
        if (!m.find() || m.groupCount() != 2) {
            throw new Exception("Could not find video download URL in view page.");
        }
        String tempId = m.group(1);
        url = JYouTube.getYouTubeGetUrl(videoId, tempId);
        File f = new File(videoFilename);
        FileOutputStream fos = new FileOutputStream(f);
        method = new GetMethod(url);
        try {
            log.debug((Object)("Making request to: " + url));
            int result = this.httpclient.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new Exception("HTTP Exception + " + result + " " + method.getStatusLine().toString());
            }
            BufferedInputStream is = new BufferedInputStream(method.getResponseBodyAsStream());
            byte[] buff = new byte[10240];
            while (-1 != ((InputStream)is).read(buff)) {
                fos.write(buff);
            }
            ((InputStream)is).close();
        }
        finally {
            method.releaseConnection();
            fos.close();
        }
    }

    public String upload(String videoFilename, String videoTitle, String videoTags, String videoDescription, Catgeory cat, String videoLanguage, boolean isPublic) throws Exception {
        int result;
        String pageHtml;
        if (!this.auth) {
            throw new Exception("Not authenticated!");
        }
        File videoFile = new File(videoFilename);
        if (!(videoFile.exists() && videoFile.isFile() && videoFile.canRead())) {
            throw new IOException("File '" + videoFilename + "' must be an existing reabable file in order to upload to YouTube!");
        }
        PostMethod method = new PostMethod(YT_URL_PUT_MYVIDEOUPLOAD);
        method.addRequestHeader("User-Agent", USER_AGENT);
        method.addParameter("field_myvideo_title", videoTitle);
        method.addParameter("field_myvideo_keywords", videoTags);
        method.addParameter("field_myvideo_descr", videoDescription);
        method.addParameter("language", videoFilename);
        method.addParameter("field_myvideo_categories", String.valueOf(cat.getCatId()));
        method.addParameter("ignore_broadcast_settings", "0");
        method.addParameter("action_upload", "1");
        method.addParameter("field_privacy", isPublic ? "public" : "private");
        try {
            int result2 = this.httpclient.executeMethod((HttpMethod)method);
            switch (result2) {
                case 200: {
                    break;
                }
                default: {
                    throw new Exception("HTTP Exception + " + result2 + " " + method.getStatusLine().toString());
                }
            }
            pageHtml = method.getResponseBodyAsString();
            if (JYouTube.isNullOrEmpty(pageHtml)) {
                throw new Exception("Empty response from YouTube server!");
            }
        }
        finally {
            method.releaseConnection();
        }
        int byteOffset = pageHtml.indexOf("id=\"theForm\"");
        if (byteOffset == -1) {
            throw new Exception("Unexpected repsonse from YouTube server! We did not receive the upload page we expected.");
        }
        byteOffset = pageHtml.lastIndexOf("<form", byteOffset);
        byteOffset = pageHtml.indexOf("action=\"", byteOffset) + 8;
        String url = pageHtml.substring(byteOffset, pageHtml.indexOf("\"", byteOffset));
        byteOffset = pageHtml.indexOf("name=\"addresser\" value=\"", byteOffset) + 24;
        String addresser = pageHtml.substring(byteOffset, pageHtml.indexOf("\"", byteOffset));
        method = new PostMethod(url);
        method.addRequestHeader("User-Agent", USER_AGENT);
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(new Part[]{new StringPart("field_command", "myvideo_submit"), new StringPart("field_myvideo_title", videoTitle), new StringPart("field_myvideo_keywords", videoTags), new StringPart("field_myvideo_descr", videoDescription), new StringPart("language", videoLanguage), new StringPart("field_myvideo_categories", String.valueOf(cat.getCatId())), new StringPart("action_upload", "1"), new StringPart("addresser", addresser), new StringPart("field_privacy", isPublic ? "public" : "private"), new ProgressReportingFilePart("field_uploadfile", videoFile, this.listeners)}, method.getParams()));
        try {
            result = this.httpclient.executeMethod((HttpMethod)method);
            switch (result) {
                default: 
            }
        }
        finally {
            method.releaseConnection();
        }
        method = new PostMethod(YT_URL_MYVIDEOS);
        try {
            result = this.httpclient.executeMethod((HttpMethod)method);
            switch (result) {
                case 200: {
                    break;
                }
                default: {
                    throw new Exception("HTTP Exception + " + result + " " + method.getStatusLine().toString());
                }
            }
            pageHtml = method.getResponseBodyAsString();
            if (JYouTube.isNullOrEmpty(pageHtml)) {
                throw new Exception("Empty response from YouTube server!");
            }
        }
        finally {
            method.releaseConnection();
        }
        byteOffset = pageHtml.indexOf("id=\"checkbox_") + 13;
        String videoId = pageHtml.substring(byteOffset, pageHtml.indexOf("\"", byteOffset));
        return videoId;
    }

    private static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.length() == 0;
    }

    protected static String getYouTubeLoginUrl(String username, String password) {
        return YT_URL_LOGIN.replace(YT_URL_LOGIN_USERNAME_KEY, username).replace(YT_URL_LOGIN_PASSWORD_KEY, password);
    }

    protected static String getYouTubeViewUrl(String videoId) {
        return YT_URL_VIEW.replace(YT_URL_VIDEOID_KEY, videoId);
    }

    protected static String getYouTubeGetUrl(String videoId, String tempId) {
        return YT_URL_GET.replace(YT_URL_VIDEOID_KEY, videoId).replace(YT_URL_VIDEOIDTEMP_KEY, tempId);
    }

    protected static HttpClient getNewHttpClient() {
        HttpClient tmpHttpclient = new HttpClient();
        tmpHttpclient.getHttpConnectionManager().getParams().setConnectionTimeout(3600000);
        tmpHttpclient.getParams().setCookiePolicy("default");
        return tmpHttpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ProgressReportingFilePart.ProgressListener listener) {
        if (listener == null) {
            return;
        }
        Collection<ProgressReportingFilePart.ProgressListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ProgressReportingFilePart.ProgressListener listener) {
        if (listener == null) {
            return true;
        }
        Collection<ProgressReportingFilePart.ProgressListener> collection = this.listeners;
        synchronized (collection) {
            return this.listeners.remove(listener);
        }
    }

    public void progressUpdate(ProgressReportingFilePart.ProgressUpdateEvent event) {
        if (event.isError()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Element '" + event.getParameterName() + "' (file '" + event.getFileName() + "'): error '" + event.getErrorMessage() + "'"));
            }
        } else if (log.isInfoEnabled()) {
            long bytesPerMilli = event.getTotalBytesSent() / event.getElapsedMillis();
            long millisRemaining = (event.getTotalBytesToSend() - event.getTotalBytesSent()) / bytesPerMilli;
            log.info((Object)("Element '" + event.getParameterName() + "' " + "(file '" + event.getFileName() + "'): " + "uploaded '" + event.getTotalBytesSent() + "' of '" + event.getTotalBytesToSend() + "' bytes: " + new BigDecimal((double)bytesPerMilli * 1000.0 / 1024.0).setScale(2, 4).toString() + "KB/s " + "(" + millisRemaining / 1000L + "s remaining)"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Catgeory {
        FILM_AND_ANIMATION(1),
        AUTO_AND_VEHICLE(2),
        MUSIC(10),
        PETS_AND_ANIMALS(15),
        SPORTS(17),
        TRAVEL_AND_PLACES(19),
        GADGETS_AND_GAMES(20),
        PEOPLE_AND_BLOGS(22),
        COMEDY(23),
        ENTERTAINMENT(24),
        NEWS_AND_POLITICS(25),
        HOWTO_AND_DIY(26);

        private final int catId;

        private Catgeory(int id) {
            this.catId = id;
        }

        public int getCatId() {
            return this.catId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProgressReportingFilePart
    extends FilePart {
        protected String parameterName;
        protected String fileName;
        protected Collection<ProgressListener> listeners = new HashSet<ProgressListener>();

        protected void sendData(OutputStream out) throws IOException {
            log.trace((Object)"enter sendData(OutputStream out)");
            if (this.lengthOfData() == 0L) {
                log.debug((Object)"No data to send.");
                return;
            }
            long bytesSent = 0L;
            long totalLength = this.getSource().getLength();
            long logEveryXBytes = totalLength / 100L;
            long logEveryXBytesNotified = 0L;
            long timeStart = System.currentTimeMillis();
            byte[] tmp = new byte[4096];
            InputStream instream = this.getSource().createInputStream();
            try {
                try {
                    ProgressUpdateEvent event;
                    int len;
                    while ((len = instream.read(tmp)) >= 0) {
                        out.write(tmp, 0, len);
                        if ((bytesSent += (long)len) < logEveryXBytesNotified + logEveryXBytes) continue;
                        logEveryXBytesNotified = bytesSent;
                        event = new ProgressUpdateEvent(totalLength, bytesSent, System.currentTimeMillis() - timeStart, null, false, this.fileName, this.parameterName);
                        this.notifyListeners(event);
                    }
                    event = new ProgressUpdateEvent(totalLength, bytesSent, System.currentTimeMillis() - timeStart, null, false, this.fileName, this.parameterName);
                    this.notifyListeners(event);
                }
                catch (IOException e) {
                    ProgressUpdateEvent event = new ProgressUpdateEvent(totalLength, bytesSent, System.currentTimeMillis() - timeStart, e.getMessage(), true, this.fileName, this.parameterName);
                    this.notifyListeners(event);
                    throw e;
                }
            }
            finally {
                instream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(ProgressListener listener) {
            if (listener == null) {
                return;
            }
            Collection<ProgressListener> collection = this.listeners;
            synchronized (collection) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(Collection<ProgressListener> listener) {
            if (listener == null) {
                return;
            }
            Collection<ProgressListener> collection = this.listeners;
            synchronized (collection) {
                this.listeners.addAll(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeListener(ProgressListener listener) {
            if (listener == null) {
                return true;
            }
            Collection<ProgressListener> collection = this.listeners;
            synchronized (collection) {
                return this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyListeners(ProgressUpdateEvent event) {
            Collection<ProgressListener> collection = this.listeners;
            synchronized (collection) {
                for (ProgressListener listener : this.listeners) {
                    try {
                        listener.progressUpdate(event);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public ProgressReportingFilePart(String parameterName, File file, Collection<ProgressListener> progressListeners) throws FileNotFoundException {
            super(parameterName, file);
            this.parameterName = parameterName;
            this.fileName = file.getName();
            this.addListener(progressListeners);
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public static interface ProgressListener {
            public void progressUpdate(ProgressUpdateEvent var1);
        }

        public static class ProgressUpdateEvent {
            protected long totalBytesToSend;
            protected long totalBytesSent;
            protected String errorMessage;
            protected boolean error;
            protected String fileName;
            protected String parameterName;
            protected long elapsedMillis;

            public boolean isError() {
                return this.error;
            }

            public String getErrorMessage() {
                return this.errorMessage;
            }

            public long getTotalBytesSent() {
                return this.totalBytesSent;
            }

            public long getTotalBytesToSend() {
                return this.totalBytesToSend;
            }

            public long getElapsedMillis() {
                return this.elapsedMillis;
            }

            public String getFileName() {
                return this.fileName;
            }

            public String getParameterName() {
                return this.parameterName;
            }

            protected ProgressUpdateEvent(long totalBytesToSend, long totalBytesSent, long elapsedMillis, String errorMessage, boolean error, String fileName, String parameterName) {
                this.totalBytesToSend = totalBytesToSend;
                this.totalBytesSent = totalBytesSent;
                this.elapsedMillis = elapsedMillis;
                this.errorMessage = errorMessage;
                this.error = error;
                this.fileName = fileName;
                this.parameterName = parameterName;
            }
        }
    }
}

