/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */
package com.jimischopp.jyoutube;

import java.math.BigDecimal;

import com.jimischopp.jyoutube.JYouTube.ProgressReportingFilePart.ProgressListener;

import junit.framework.TestCase;

public class JYouTubeTest extends TestCase implements ProgressListener {
	
	public void testJYouTubeDownload() throws Exception
	{
		JYouTube tube = new JYouTube ();
		tube.download("6dYEorlW-IQ","park_jazz.flv");
	}
	
	
	public void testJYouTubeUpload() throws Exception
	{
		JYouTube tube = new JYouTube ("yourYouTubeUsername","yourYouTubePassword");
		
		//tube.addListener(tube);
		tube.addListener(this);
		
		String id = tube.upload("MVI_0193.AVI","JYouTube Damnit", "JYouTube", "Video uploaded automatically with JYouTube", JYouTube.Catgeory.MUSIC, "US", true);		
		System.out.println("New youtube video id is:" + id);
	}	
	
	
	
	public void progressUpdate(com.jimischopp.jyoutube.JYouTube.ProgressReportingFilePart.ProgressUpdateEvent event) {
		if(event.isError()) {
			System.out.println("Element '"+event.getParameterName()+"' (file '"+event.getFileName()+"'): error '"+event.getErrorMessage()+"'");
			
		} else {

				long bytesPerMilli = event.getTotalBytesSent() / event.getElapsedMillis();
				long millisRemaining = (event.getTotalBytesToSend() - event.getTotalBytesSent()) / bytesPerMilli;
				System.out.println("File '"+ event.getFileName()+"': " +
								   		new BigDecimal(((double)bytesPerMilli*1000D)/1024D).setScale(2, BigDecimal.ROUND_HALF_UP).toString() + "KB/s " +
								   		"(" + (millisRemaining/1000) + "s remaining)"
								   );

		}
	}
}
