/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */
package com.jimischopp.msdpapi;

/**
 * A JNI wrapper around the MS DPAPI Encryption library. Encrypts/Decrypts strings using the
 * Microsoft DPAPI library (in Crypt32.dll). This has the restriction that the original string
 * must be decrypted on the same machine it was encrypted on, since the MSDPAPIJava library
 * uses the Machine-level store.
 * <p>
 * To use this API (obviously only on Windows), simply place MSDPAPIJava.dll in your library path,
 * and then include/call the static methods on this class. For example:
 * 
 * 
 * <code><pre>
 * 		System.out.println(com.jimischopp.msdpapi.MSDPAPIJava.CryptProtectData("lalafdsfds"));
 * </pre></code>
 * 
 * would render something similar to:
 * <code><pre>
 * 		AQAAANCMnd8BFdERjHoAwE/Cl+sBAAAA6cdt4K6RPUOd0SuEQ3rAIgQAAAAKAAAAVzJLRHVtbXkAAANmAACoAAAAEAAAAEP7/vnKVT6
 * </pre></code>
 * 
 * and passing this long cypher-text to CryptUnprotectData would again yield the original "lalafdsfds".
 * 
 * 
 * <p>
 * Copyright 2004, James Schopp
 *
 * @author James Schopp
 *
 **/
public class MSDPAPIJava {
	
    static {
        System.loadLibrary("MSDPAPIJava");
    }

    /**
     * Encrypts a string using the MS DPAPI Machine-level encryption key.
     * @param clearText the original clear text
     * @return the encrypted text
     */
	public static native String CryptProtectData(String clearText);
	
	/**
	 * Unencrypts a cyphertext string using the MS DPAPI Machine-level encryption key.
	 * 
	 * @param cypherText the encrypted text
	 * @return the original clear text
	 */
	public static native String CryptUnprotectData(String cypherText);
}
