/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.checkstyle;

import com.jimischopp.checkstyle.AbstractBaseChecker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Pattern;

public class ResourceUseInLoopCheck
extends AbstractBaseChecker {
    public final String DEFAULT_RESOURCE_FORMAT = "conn.*";
    private Pattern mRegexp;
    private String mFormat;
    private boolean resourceIsParam = true;

    public ResourceUseInLoopCheck() {
        this.setFormat("conn.*");
    }

    public void setFormat(String aFormat) {
        this.mRegexp = Utils.getPattern((String)aFormat);
        this.mFormat = aFormat;
    }

    public Pattern getRegexp() {
        return this.mRegexp;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public int[] getDefaultTokens() {
        if (this.resourceIsParam) {
            return new int[]{58};
        }
        return new int[]{27};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 27: {
                this.visitToken_METHOD(ast);
                return;
            }
            case 58: {
                this.visitToken_PARAMETERS(ast);
                return;
            }
        }
    }

    private void visitToken_PARAMETERS(DetailAST ast) {
        DetailAST astExpr = this.getParentType(ast, 28);
        if (astExpr == null) {
            return;
        }
        DetailAST astMeth = this.getParentType(astExpr, 27);
        if (astMeth == null) {
            return;
        }
        String strParams = this.toString(ast);
        int indx = strParams.lastIndexOf(46);
        if (indx != -1) {
            strParams = strParams.substring(indx + 1);
        }
        if (!this.getRegexp().matcher(strParams).matches()) {
            return;
        }
        if (this.isInsideLoop(ast)) {
            this.log(ast, "resourceUseInLoopCheck");
            return;
        }
    }

    private void visitToken_METHOD(DetailAST ast) {
        String strMethodCall = this.toString(ast);
        int indx = strMethodCall.lastIndexOf(46);
        if (indx != -1) {
            strMethodCall = strMethodCall.substring(indx + 1);
        }
        if (!this.getRegexp().matcher(strMethodCall).matches()) {
            return;
        }
        if (this.isInsideLoop(ast)) {
            this.log(ast, "resourceUseInLoopCheck");
            return;
        }
    }

    public boolean isResourceIsParam() {
        return this.resourceIsParam;
    }

    public void setResourceIsParam(boolean resourceIsParam) {
        this.resourceIsParam = resourceIsParam;
    }
}

