/*
 * Decompiled with CFR 0.152.
 */
package com.jimischopp.checkstyle;

import com.jimischopp.checkstyle.AbstractBaseChecker;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WastefulParseNumCheck
extends AbstractBaseChecker {
    private static final String PKG_JAVA_LANG = "java.lang.";
    private static final short NOTWRAPPER = -1;
    private static final short LONG = 0;
    private static final short SHORT = 1;
    private static final short INTEGER = 2;
    private static final short DOUBLE = 3;
    private static final short FLOAT = 4;
    private static final short BYTE = 5;
    private static final short STRING = 6;
    private static final String[] WRAPPERTYPES = new String[]{"Long", "Short", "Integer", "Double", "Float", "Byte"};
    private static final String[] WRAPPERMETHODS = new String[]{"longValue", "shortValue", "intValue", "doubleValue", "floatValue", "byteValue", "toString"};

    public int[] getDefaultTokens() {
        return new int[]{136};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    private short getWrapperType(String strType) {
        if (strType.indexOf(PKG_JAVA_LANG) == 0) {
            strType = strType.substring(PKG_JAVA_LANG.length() - 1);
        }
        if (WRAPPERTYPES[0].equals(strType)) {
            return 0;
        }
        if (WRAPPERTYPES[1].equals(strType)) {
            return 1;
        }
        if (WRAPPERTYPES[2].equals(strType)) {
            return 2;
        }
        if (WRAPPERTYPES[3].equals(strType)) {
            return 3;
        }
        if (WRAPPERTYPES[4].equals(strType)) {
            return 4;
        }
        if (WRAPPERTYPES[5].equals(strType)) {
            return 5;
        }
        return -1;
    }

    private short getWrapperMethod(String strMethod) {
        int iLastDot = strMethod.lastIndexOf(46);
        if (iLastDot != -1) {
            strMethod = strMethod.substring(iLastDot + 1);
        }
        if (WRAPPERMETHODS[0].equals(strMethod)) {
            return 0;
        }
        if (WRAPPERMETHODS[1].equals(strMethod)) {
            return 1;
        }
        if (WRAPPERMETHODS[2].equals(strMethod)) {
            return 2;
        }
        if (WRAPPERMETHODS[3].equals(strMethod)) {
            return 3;
        }
        if (WRAPPERMETHODS[4].equals(strMethod)) {
            return 4;
        }
        if (WRAPPERMETHODS[5].equals(strMethod)) {
            return 5;
        }
        if (WRAPPERMETHODS[6].equals(strMethod)) {
            return 6;
        }
        return -1;
    }

    public void visitToken(DetailAST ast) {
        String strType = this.toString(ast);
        short shtType = this.getWrapperType(strType);
        if (-1 == shtType) {
            return;
        }
        DetailAST astWrapperMeth = this.getParentType(ast, 27);
        if (astWrapperMeth == null) {
            return;
        }
        String strMethod = this.toString(astWrapperMeth);
        short shtMethod = this.getWrapperMethod(strMethod);
        if (-1 == shtMethod) {
            return;
        }
        this.log(ast, "wastefulParseNumCheck");
    }
}

