/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */
package com.jimischopp.checkstyle.test;


import junit.framework.Test;
import junit.framework.TestSuite;

import com.jimischopp.checkstyle.ResourceUseInLoopCheck;
import com.jimischopp.checkstyle.WastefulDateCreationCheck;
import com.jimischopp.checkstyle.WastefulParseNumCheck;
import com.puppycrawl.tools.checkstyle.BaseCheckTestCase;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;

/**
 * 
 * <p>
 * Copyright 2003, James Schopp
 *
 * @author James Schopp
 * @see com.puppycrawl.tools.checkstyle.api.Check
 * @since Oct 27, 2003
 * 
 */
public class ResourceUseChecksTest extends BaseCheckTestCase
{
	static {
		System.setProperty("testinputs.dir", "src/com/jimischopp/checkstyle/test");
	}
	
	public static void main(String[] args) {
		junit.textui.TestRunner.run(ResourceUseChecksTest.class);
	}
	
	public static Test suite() {
		TestSuite suite =
			new TestSuite("Tests for ResourceUse*** Checks");
		
		suite.addTest(new TestSuite(ResourceUseChecksTest.class));
		return suite;
	}
	
	
	public void testWastedWrapperObject() throws Exception
    {
        final DefaultConfiguration checkConfig =
            createCheckConfig(WastefulParseNumCheck.class);
        final String[] expected = {
                "Audit done.",
        };
        verify(checkConfig, getPath("TestResourceUsage.java"), expected);
        
    }
    
    public void testWastedDateObject() throws Exception
    {
        final DefaultConfiguration checkConfig =
            createCheckConfig(WastefulDateCreationCheck.class);
        final String[] expected = {
                "Audit done.",
        };
        verify(checkConfig, getPath("TestResourceUsage.java"), expected);
        
    }
    
    public void testQueryInLoop() throws Exception
    {
        final DefaultConfiguration checkConfig =
            createCheckConfig(ResourceUseInLoopCheck.class);
        final String[] expected = {
                "Audit done.",
        };
        verify(checkConfig, getPath("TestResourceUsage.java"), expected);
        
    }
	
}